/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.CECInfo;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.hsc.common.util.PartitionInfo;
import com.ibm.hsc.common.util.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class CIMUtils {
    public static final char MACHINE_TYPE_MODEL_AND_SERIAL_SEPARATOR_CHAR = '_';
    private static final char CIM_MACHINE_TYPE_MODEL_AND_SERIAL_SEPARATOR_CHAR = '*';
    public static final char CIM_PARTITION_NAME_SEPARATOR_CHAR = '*';
    private static final String TRACE_MASKD = "JCIMUTLD";
    private static final String TRACE_MASKF = "JCIMUTLF";
    private static final String TRACE_MASKT = "JCIMUTLT";

    private CIMUtils() {
    }

    public static void main(String[] stringArray) {
        Vector vector = null;
        CECInfo cECInfo = null;
        Hashtable hashtable = null;
        try {
            Object object;
            vector = CIMUtils.getCECsInfo();
            if (vector != null && vector.size() > 0) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    cECInfo = (CECInfo)object.nextElement();
                    System.out.println("Got CEC by getCECsInfo: " + cECInfo.getCECModelType() + ", " + cECInfo.getCECSerialNumber() + ", " + cECInfo.getCECMachineName());
                }
            } else {
                System.out.println("No CECs found by getCECsInfo.");
            }
            vector = CIMUtils.getCECs();
            if (vector != null && vector.size() > 0) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    System.out.println("Got CEC by getCECs: " + (String)object.nextElement());
                }
            } else {
                System.out.println("No CECs found by getCECs.");
            }
            vector = CIMUtils.getPartitions("XYZ", "1234567");
            if (vector != null && vector.size() > 0) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    System.out.println("Got partition by getPartitions: " + (String)object.nextElement());
                }
            } else {
                System.out.println("No partitions found by getCECs.");
            }
            hashtable = CIMUtils.getPartitionInfo();
            if (hashtable != null) {
                object = hashtable.values().iterator();
                while (object.hasNext()) {
                    System.out.println("Got partition by getPartitionInfo: " + (PartitionInfo)object.next());
                }
            } else {
                System.out.println("No partitions found by getPartitionInfo.");
            }
        }
        catch (CIMException cIMException) {
            System.out.println((Object)cIMException);
        }
    }

    public static Vector getCECsInfo() throws CIMException {
        Enumeration enumeration = null;
        Vector vector = null;
        Vector<CECInfo> vector2 = null;
        Vector vector3 = null;
        Vector<String> vector4 = null;
        vector4 = new Vector<String>(3);
        vector4.addElement("Model");
        vector4.addElement("SerialNumber");
        vector4.addElement("UserDefinedName");
        enumeration = CIMUtils.getInstances("IBMHSC_ComputerSystem");
        vector = CIMUtils.getValues(enumeration, vector4);
        if (vector != null) {
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                vector3 = (Vector)enumeration2.nextElement();
                if (vector2 == null) {
                    vector2 = new Vector<CECInfo>();
                }
                vector2.addElement(new CECInfo((String)vector3.elementAt(0), (String)vector3.elementAt(1), (String)vector3.elementAt(2)));
            }
        }
        return vector2;
    }

    public static Vector getCECs() throws CIMException {
        Enumeration enumeration = null;
        Vector vector = null;
        Vector<String> vector2 = null;
        Vector vector3 = null;
        Vector<String> vector4 = null;
        vector4 = new Vector<String>(2);
        vector4.addElement("Model");
        vector4.addElement("SerialNumber");
        enumeration = CIMUtils.getInstances("IBMHSC_ComputerSystem");
        vector = CIMUtils.getValues(enumeration, vector4);
        if (vector != null) {
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                vector3 = (Vector)enumeration2.nextElement();
                if (vector2 == null) {
                    vector2 = new Vector<String>();
                }
                vector2.addElement((String)vector3.elementAt(0) + '_' + (String)vector3.elementAt(1));
            }
        }
        return vector2;
    }

    public static Vector getHSCs(String string, String string2) throws CIMException {
        Hashtable<String, String> hashtable = null;
        CIMObjectPath cIMObjectPath = null;
        String string3 = null;
        String string4 = null;
        Vector<CIMProperty> vector = null;
        Vector<CIMProperty> vector2 = null;
        Hashtable<String, String> hashtable2 = null;
        Hashtable<String, String> hashtable3 = null;
        CIMValue cIMValue = null;
        short s = 0;
        short s2 = 0;
        boolean bl = false;
        int n = 0;
        String string5 = null;
        String string6 = null;
        String string7 = CIMUtils._getHostName();
        Vector<Hashtable<String, String>> vector3 = null;
        hashtable2 = new Hashtable<String, String>(1);
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
        if (cIMObjectPath != null) {
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    string4 = (String)hashtable.get(string3);
                    cIMObjectPath.addKey(string3, new CIMValue((Object)string4));
                }
            }
            vector2 = new Vector<CIMProperty>();
            vector2.setSize(1);
            vector2.setElementAt(new CIMProperty("NumOfSlot", new CIMValue((Object)new UnsignedInt8(0), new CIMDataType(1))), 0);
            cIMValue = HscUtil.invokeCIMMethod(string7, cIMObjectPath, "GetNumberOfHscInfoSlot", null, vector2);
            if (cIMValue == null) {
                return null;
            }
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).shortValue();
            vector2 = new Vector();
            vector2.setSize(1);
            vector2.setElementAt(new CIMProperty("SlotID", new CIMValue((Object)new UnsignedInt8(0), new CIMDataType(1))), 0);
            cIMValue = HscUtil.invokeCIMMethod(string7, cIMObjectPath, "GetHostHscInfoSlotID", null, vector2);
            if (cIMValue == null) {
                return null;
            }
            s2 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).shortValue();
            short s3 = 0;
            while (s3 < 0 + s) {
                string5 = "";
                vector = new Vector<CIMProperty>();
                vector.setSize(2);
                vector.setElementAt(new CIMProperty("SlotID", new CIMValue((Object)new UnsignedInt8(s3))), 0);
                vector.setElementAt(new CIMProperty("DataTag", new CIMValue((Object)new String("HscIPAddr"))), 1);
                vector2 = new Vector();
                vector2.setSize(2);
                vector2.setElementAt(new CIMProperty("DataLength", new CIMValue((Object)new UnsignedInt16(0), new CIMDataType(3))), 0);
                vector2.setElementAt(new CIMProperty("Data", new CIMValue((Object)"", new CIMDataType(9))), 1);
                cIMValue = HscUtil.invokeCIMMethod(string7, cIMObjectPath, "GetHscInfo", vector, vector2);
                if (cIMValue != null) {
                    n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                    if (n > 0) {
                        string5 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                        if (string5 == null) {
                            string5 = "";
                        }
                    } else {
                        string5 = "";
                    }
                }
                string6 = "";
                vector = new Vector();
                vector.setSize(2);
                vector.setElementAt(new CIMProperty("SlotID", new CIMValue((Object)new UnsignedInt8(s3))), 0);
                vector.setElementAt(new CIMProperty("DataTag", new CIMValue((Object)new String("HscName"))), 1);
                vector2 = new Vector();
                vector2.setSize(2);
                vector2.setElementAt(new CIMProperty("DataLength", new CIMValue((Object)new UnsignedInt16(0), new CIMDataType(3))), 0);
                vector2.setElementAt(new CIMProperty("Data", new CIMValue((Object)"", new CIMDataType(9))), 1);
                cIMValue = HscUtil.invokeCIMMethod(string7, cIMObjectPath, "GetHscInfo", vector, vector2);
                if (cIMValue != null) {
                    n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                    if (n > 0) {
                        string6 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                        if (string6 == null) {
                            string6 = "";
                        }
                    } else {
                        string6 = "";
                    }
                }
                if (string6.length() > 0 || string5.length() > 0) {
                    if ((string6 = CIMUtils.replaceFirst(string6, '*', '_')).indexOf(45) == -1 && string6.length() >= 4) {
                        string6 = string6.substring(0, 4) + "-" + string6.substring(4);
                    }
                    if (s3 != s2) {
                        if (hashtable3 == null) {
                            hashtable3 = new Hashtable<String, String>();
                        }
                        hashtable3.put(string5, string6);
                    } else {
                        hashtable2 = new Hashtable(1);
                        hashtable2.put(string5, string6);
                    }
                }
                s3 = (short)(s3 + 1);
            }
        }
        if (hashtable2 != null) {
            vector3 = new Vector<Hashtable<String, String>>(2);
            vector3.addElement(hashtable2);
            if (hashtable3 != null) {
                vector3.addElement(hashtable3);
            }
        }
        return vector3;
    }

    public static Hashtable getOtherHSCs(String string, String string2) throws CIMException {
        Hashtable<String, String> hashtable = null;
        CIMObjectPath cIMObjectPath = null;
        String string3 = null;
        String string4 = null;
        Vector<CIMProperty> vector = null;
        Vector<CIMProperty> vector2 = null;
        Hashtable<String, String> hashtable2 = null;
        CIMValue cIMValue = null;
        short s = 0;
        short s2 = 0;
        boolean bl = false;
        int n = 0;
        String string5 = null;
        String string6 = null;
        String string7 = CIMUtils._getHostName();
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
        if (cIMObjectPath != null) {
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    string4 = (String)hashtable.get(string3);
                    cIMObjectPath.addKey(string3, new CIMValue((Object)string4));
                }
            }
            vector2 = new Vector<CIMProperty>();
            vector2.setSize(1);
            vector2.setElementAt(new CIMProperty("NumOfSlot", new CIMValue((Object)new UnsignedInt8(0), new CIMDataType(1))), 0);
            cIMValue = HscUtil.invokeCIMMethod(string7, cIMObjectPath, "GetNumberOfHscInfoSlot", null, vector2);
            if (cIMValue == null) {
                return null;
            }
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).shortValue();
            vector2 = new Vector();
            vector2.setSize(1);
            vector2.setElementAt(new CIMProperty("SlotID", new CIMValue((Object)new UnsignedInt8(0), new CIMDataType(1))), 0);
            cIMValue = HscUtil.invokeCIMMethod(string7, cIMObjectPath, "GetHostHscInfoSlotID", null, vector2);
            if (cIMValue == null) {
                return null;
            }
            s2 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).shortValue();
            short s3 = 0;
            while (s3 < 0 + s) {
                if (s3 != s2) {
                    string5 = "";
                    vector = new Vector<CIMProperty>();
                    vector.setSize(2);
                    vector.setElementAt(new CIMProperty("SlotID", new CIMValue((Object)new UnsignedInt8(s3))), 0);
                    vector.setElementAt(new CIMProperty("DataTag", new CIMValue((Object)new String("HscIPAddr"))), 1);
                    vector2 = new Vector();
                    vector2.setSize(2);
                    vector2.setElementAt(new CIMProperty("DataLength", new CIMValue((Object)new UnsignedInt16(0), new CIMDataType(3))), 0);
                    vector2.setElementAt(new CIMProperty("Data", new CIMValue((Object)"", new CIMDataType(9))), 1);
                    cIMValue = HscUtil.invokeCIMMethod(string7, cIMObjectPath, "GetHscInfo", vector, vector2);
                    if (cIMValue != null) {
                        n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                        if (n > 0) {
                            string5 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                            if (string5 == null) {
                                string5 = "";
                            }
                        } else {
                            string5 = "";
                        }
                    }
                    string6 = "";
                    vector = new Vector();
                    vector.setSize(2);
                    vector.setElementAt(new CIMProperty("SlotID", new CIMValue((Object)new UnsignedInt8(s3))), 0);
                    vector.setElementAt(new CIMProperty("DataTag", new CIMValue((Object)new String("HscName"))), 1);
                    vector2 = new Vector();
                    vector2.setSize(2);
                    vector2.setElementAt(new CIMProperty("DataLength", new CIMValue((Object)new UnsignedInt16(0), new CIMDataType(3))), 0);
                    vector2.setElementAt(new CIMProperty("Data", new CIMValue((Object)"", new CIMDataType(9))), 1);
                    cIMValue = HscUtil.invokeCIMMethod(string7, cIMObjectPath, "GetHscInfo", vector, vector2);
                    if (cIMValue != null) {
                        n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                        if (n > 0) {
                            string6 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                            if (string6 == null) {
                                string6 = "";
                            }
                        } else {
                            string6 = "";
                        }
                    }
                    if (string6.length() > 0 || string5.length() > 0) {
                        if ((string6 = CIMUtils.replaceFirst(string6, '*', '_')).indexOf(45) == -1 && string6.length() >= 4) {
                            string6 = string6.substring(0, 4) + "-" + string6.substring(4);
                        }
                        if (hashtable2 == null) {
                            hashtable2 = new Hashtable<String, String>();
                        }
                        hashtable2.put(string5, string6);
                    }
                }
                s3 = (short)(s3 + 1);
            }
        }
        return hashtable2;
    }

    public static CIMInstance getInstance(String string, Hashtable hashtable) throws CIMException {
        CIMObjectPath cIMObjectPath = null;
        CIMInstance cIMInstance = null;
        String string2 = null;
        String string3 = null;
        String string4 = CIMUtils._getHostName();
        cIMObjectPath = new CIMObjectPath(string, "root/ibmhscV3_2");
        if (cIMObjectPath != null) {
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    string3 = (String)hashtable.get(string2);
                    cIMObjectPath.addKey(string2, new CIMValue((Object)string3));
                }
            }
            cIMInstance = HscUtil.getCIMInstance(string4, cIMObjectPath, false);
        }
        return cIMInstance;
    }

    public static Enumeration getAssociators(String string, String string2, String string3, Hashtable hashtable) throws CIMException {
        CIMObjectPath cIMObjectPath = null;
        String string4 = null;
        String string5 = null;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        String string6 = CIMUtils._getHostName();
        enumeration = new Vector().elements();
        cIMObjectPath = new CIMObjectPath(string, "root/ibmhscV3_2");
        if (cIMObjectPath != null) {
            if (hashtable != null) {
                Enumeration enumeration3 = hashtable.keys();
                while (enumeration3.hasMoreElements()) {
                    string4 = (String)enumeration3.nextElement();
                    string5 = (String)hashtable.get(string4);
                    cIMObjectPath.addKey(string4, new CIMValue((Object)string5));
                }
            }
            if ((enumeration2 = HscUtil.getCIMAssociation(string6, cIMObjectPath, string2, string3, null, null)) != null) {
                return enumeration2;
            }
        }
        return enumeration;
    }

    public static Vector getIODrawers(String string, String string2) throws CIMException {
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration = null;
        Vector vector = null;
        Vector<String> vector2 = null;
        Vector<String> vector3 = null;
        vector3 = new Vector<String>(1);
        vector3.addElement("DeviceID");
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        enumeration = CIMUtils.getAssociators("IBMHSC_ComputerSystem", "IBMHSC_CompSysIODrawer", "IBMHSC_IODrawer", hashtable);
        vector = CIMUtils.getValues(enumeration, vector3);
        if (vector != null) {
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string3;
                if (vector2 == null) {
                    vector2 = new Vector<String>();
                }
                String string4 = (String)((Vector)enumeration2.nextElement()).elementAt(0);
                Trace.trace(TRACE_MASKD, "I/O drawers found in getIODrawers :" + string4);
                if (string4.indexOf(string) != -1) continue;
                int n = string4.length();
                if (string4.endsWith("-P1") || string4.endsWith("-P2")) {
                    n -= 3;
                }
                if (vector2.contains(string3 = CIMUtils.replaceFirst(string4 = string4.substring(0, n), '*', '_'))) continue;
                vector2.addElement(string3);
            }
        } else {
            Trace.trace(TRACE_MASKD, "no I/O drawers found in getIODrawers.");
        }
        return vector2;
    }

    public static Vector getUnallocatedIODrawers(String string, String string2) throws CIMException {
        Hashtable<String, String> hashtable = null;
        Hashtable<String, String> hashtable2 = null;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        Vector<String> vector = null;
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        UnsignedInt8 unsignedInt8 = null;
        CIMInstance cIMInstance2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        boolean bl = false;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt16 unsignedInt162 = null;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        Date date = null;
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        enumeration = CIMUtils.getAssociators("IBMHSC_ComputerSystem", "IBMHSC_CompSysIODrawer", "IBMHSC_IODrawer", hashtable);
        String string10 = CIMUtils._getHostName();
        date = new Date();
        vector = new Vector<String>();
        vector.addElement("*FC ????????\n*VC 20.0\n*N2 " + date + "\n");
        while (enumeration.hasMoreElements()) {
            cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            cIMInstance = HscUtil.getCIMInstance(string10, cIMObjectPath, false);
            if (cIMInstance == null) continue;
            hashtable2 = new Hashtable<String, String>();
            hashtable2.put("CreationClassName", "IBMHSC_IODrawer");
            hashtable2.put("DeviceID", (String)cIMInstance.getProperty("DeviceID").getValue().getValue());
            hashtable2.put("SystemCreationClassName", (String)cIMInstance.getProperty("SystemCreationClassName").getValue().getValue());
            hashtable2.put("SystemName", (String)cIMInstance.getProperty("SystemName").getValue().getValue());
            string7 = "";
            cIMProperty = cIMInstance.getProperty("PhysicalLocation");
            if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                string7 = (String)cIMValue.getValue();
            }
            if (string7 == null) {
                string7 = "";
            }
            enumeration2 = CIMUtils.getAssociators("IBMHSC_IODrawer", "IBMHSC_IODrawerSlot", "IBMHSC_PCISlot", hashtable2);
            while (enumeration2.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration2.nextElement();
                cIMInstance2 = HscUtil.getCIMInstance(string10, cIMObjectPath2, false);
                if (cIMInstance2 == null || (cIMProperty = cIMInstance2.getProperty("State")) == null || (cIMValue = cIMProperty.getValue()) == null || (unsignedInt8 = (UnsignedInt8)cIMValue.getValue()) == null || unsignedInt8.shortValue() == 8 || unsignedInt8.shortValue() != 7) continue;
                bl = false;
                cIMProperty = cIMInstance2.getProperty("VendorID");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null && (unsignedInt16 = (UnsignedInt16)cIMValue.getValue()) != null && unsignedInt16.intValue() == 65535 && (cIMProperty = cIMInstance2.getProperty("DeviceID")) != null && (cIMValue = cIMProperty.getValue()) != null && (unsignedInt162 = (UnsignedInt16)cIMValue.getValue()) != null && unsignedInt162.intValue() == 65535) {
                    bl = true;
                }
                if (bl) continue;
                string3 = "";
                string4 = "";
                cIMProperty = cIMInstance2.getProperty("IODrawerDeviceID");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null && (string5 = (String)cIMValue.getValue()) != null && (n = string5.indexOf(42)) != -1) {
                    if (n > 0) {
                        string3 = string5.substring(0, n);
                    }
                    if (n + 1 < string5.length()) {
                        int n2 = string5.length();
                        if (string5.endsWith("-P1") || string5.endsWith("-P2")) {
                            n2 -= 3;
                        }
                        string4 = string5.substring(n + 1, n2);
                    }
                }
                if (string3 == null) {
                    string3 = "";
                }
                if (string4 == null) {
                    string4 = "";
                }
                string6 = "";
                cIMProperty = cIMInstance2.getProperty("SlotLocation");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    string6 = (String)cIMValue.getValue();
                }
                if (string6 == null) {
                    string6 = "";
                }
                string9 = "";
                cIMProperty = cIMInstance2.getProperty("ClassCodeInfo");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    string9 = (String)cIMValue.getValue();
                }
                if (string9 == null) {
                    string9 = "";
                }
                string8 = "";
                cIMProperty = cIMInstance2.getProperty("ClassCode");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    string8 = (String)cIMValue.getValue();
                }
                if (string8 == null) {
                    string8 = "";
                }
                vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS " + string9 + "\n" + "*TM " + string3 + "\n" + "*SE " + string4 + "\n" + "*YL " + string7 + "-" + string6 + "\n" + "*VI " + string8 + "\n");
            }
        }
        return vector;
    }

    public static String getVPD() throws CIMException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        String string = null;
        Enumeration enumeration = CIMUtils.getInstances("IBMHSC_Console");
        if (enumeration.hasMoreElements()) {
            cIMInstance = (CIMInstance)enumeration.nextElement();
            cIMProperty = cIMInstance.getProperty("VPD");
            if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                string = (String)cIMValue.getValue();
                cIMProperty = cIMInstance.getProperty("HMCVersion");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    string = string + "*FC ????????\n*DS Platform Firmware\n*RM " + (String)cIMValue.getValue() + "\n";
                }
            }
        }
        if (string != null && string.length() > 0) {
            Date date = new Date();
            string = "*FC ????????\n*VC 20.0\n*N2 " + date + "\n" + string;
        }
        return string;
    }

    public static Vector getValues(Enumeration enumeration, Vector vector) throws CIMException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        String string = null;
        Vector<Vector<String>> vector2 = null;
        Vector<String> vector3 = null;
        Object var8_8 = null;
        if (enumeration != null && vector != null && vector.size() > 0) {
            String string2 = CIMUtils._getHostName();
            while (enumeration.hasMoreElements()) {
                var8_8 = enumeration.nextElement();
                if (var8_8 instanceof CIMInstance) {
                    cIMInstance = var8_8;
                } else {
                    cIMInstance = HscUtil.getCIMInstance(string2, var8_8, false);
                    if (cIMInstance == null) continue;
                }
                vector3 = new Vector<String>(vector.size());
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    string = "";
                    String string3 = (String)enumeration2.nextElement();
                    cIMProperty = cIMInstance.getProperty(string3);
                    if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null && (string = (String)cIMValue.getValue()) == null) {
                        string = "";
                    }
                    vector3.addElement(string);
                }
                if (vector2 == null) {
                    vector2 = new Vector<Vector<String>>();
                }
                vector2.addElement(vector3);
            }
        }
        return vector2;
    }

    public static String getValue(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        if (cIMInstance != null && (cIMProperty = cIMInstance.getProperty(string)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            return (String)cIMValue.getValue();
        }
        return null;
    }

    public static Enumeration getInstances(String string) throws CIMException {
        return CIMUtils.getInstances(string, new CIMObjectPath(string));
    }

    private static Enumeration getInstances(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        Enumeration enumeration = null;
        String string2 = CIMUtils._getHostName();
        if (cIMObjectPath != null) {
            enumeration = HscUtil.getCIMEnumInstances(string2, cIMObjectPath, true, false);
        }
        return enumeration;
    }

    private static String replaceFirst(String string, char c, char c2) {
        int n = 0;
        StringBuffer stringBuffer = null;
        if (string != null && (n = string.indexOf(c)) != -1) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(n, c2);
            return stringBuffer.toString();
        }
        return string;
    }

    public static Vector getPartitionProperties(String string, String string2, String string3) throws CIMException {
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration = null;
        Vector<String> vector = null;
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        String string4 = null;
        CIMObjectPath cIMObjectPath = null;
        String string5 = CIMUtils._getHostName();
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        enumeration = CIMUtils.getAssociators("IBMHSC_ComputerSystem", "IBMHSC_CompSysPartition", "IBMHSC_Partition", hashtable);
        while (enumeration.hasMoreElements()) {
            string4 = "";
            cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            cIMInstance = HscUtil.getCIMInstance(string5, cIMObjectPath, false);
            if (cIMInstance != null && (cIMProperty = cIMInstance.getProperty(string3)) != null && (cIMValue = cIMProperty.getValue()) != null && (string4 = (String)cIMValue.getValue()) == null) {
                string4 = "";
            }
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(string4);
        }
        return vector;
    }

    public static Vector getPartitions(String string, String string2) throws CIMException {
        return CIMUtils.getPartitionProperties(string, string2, "UserDefinedName");
    }

    public static Vector getPartitionKeyNames(String string, String string2) throws CIMException {
        return CIMUtils.getPartitionProperties(string, string2, "Name");
    }

    private static String _getHostName() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            if (string != null && string.length() > 0) {
                return string;
            }
        }
        catch (Exception exception) {}
        return "localhost";
    }

    public static boolean isInSMPMode(String string, String string2) throws CIMException, IOException {
        CIMProperty cIMProperty = null;
        CIMInstance cIMInstance = null;
        CIMValue cIMValue = null;
        UnsignedInt8 unsignedInt8 = null;
        Hashtable<String, String> hashtable = null;
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        cIMInstance = CIMUtils.getInstance("IBMHSC_ComputerSystem", hashtable);
        if (cIMInstance != null) {
            cIMProperty = cIMInstance.getProperty("Mode");
            if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null && (unsignedInt8 = (UnsignedInt8)cIMValue.getValue()) != null) {
                return unsignedInt8.intValue() == 0;
            }
            throw new CIMException("");
        }
        throw new IOException("");
    }

    public static Hashtable getPartitionInfo() throws CIMException {
        Enumeration enumeration = null;
        Vector vector = null;
        Vector vector2 = null;
        Vector<String> vector3 = null;
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration2 = null;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = null;
        String string = CIMUtils._getHostName();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        CIMValue cIMValue = null;
        UnsignedInt8 unsignedInt8 = null;
        Hashtable<String, PartitionInfo> hashtable2 = null;
        CIMInstance cIMInstance2 = null;
        CIMProperty cIMProperty = null;
        UnsignedInt8 unsignedInt82 = null;
        boolean bl = false;
        boolean bl2 = false;
        CIMInstance cIMInstance3 = null;
        Enumeration enumeration3 = null;
        UnsignedInt8 unsignedInt83 = null;
        String string5 = null;
        boolean bl3 = false;
        PartitionInfo partitionInfo = null;
        hashtable2 = new Hashtable<String, PartitionInfo>();
        vector3 = new Vector<String>(2);
        vector3.addElement("Model");
        vector3.addElement("SerialNumber");
        enumeration = CIMUtils.getInstances("IBMHSC_ComputerSystem");
        vector = CIMUtils.getValues(enumeration, vector3);
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                vector2 = (Vector)iterator.next();
                string2 = (String)vector2.elementAt(0);
                string3 = (String)vector2.elementAt(1);
                hashtable = new Hashtable<String, String>();
                hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
                hashtable.put("Name", string2 + '*' + string3);
                bl = false;
                bl2 = false;
                cIMInstance2 = CIMUtils.getInstance("IBMHSC_ComputerSystem", hashtable);
                if (cIMInstance2 != null && (cIMProperty = cIMInstance2.getProperty("Mode")) != null && (cIMValue = cIMProperty.getValue()) != null && (unsignedInt82 = (UnsignedInt8)cIMValue.getValue()) != null) {
                    bl2 = true;
                    if (unsignedInt82.intValue() == 0) {
                        bl = true;
                    }
                }
                if (!bl2) {
                    throw new CIMException("");
                }
                enumeration2 = CIMUtils.getAssociators("IBMHSC_ComputerSystem", "IBMHSC_CompSysPartition", "IBMHSC_Partition", hashtable);
                while (enumeration2.hasMoreElements()) {
                    partitionInfo = null;
                    string4 = null;
                    cIMObjectPath = (CIMObjectPath)enumeration2.nextElement();
                    cIMInstance = HscUtil.getCIMInstance(string, cIMObjectPath, false);
                    if (cIMInstance != null && (string4 = (String)CIMUtils.getPropertyValue(cIMInstance, "Name")) != null && (string5 = (String)CIMUtils.getPropertyValue(cIMInstance, "UserDefinedName")) != null && (unsignedInt8 = (UnsignedInt8)CIMUtils.getPropertyValue(cIMInstance, "PartitionState")) != null) {
                        bl3 = false;
                        if (unsignedInt8.intValue() == 8 && (enumeration3 = HscUtil.getCIMAssociationInst(CIMUtils._getHostName(), cIMObjectPath, "IBMHSC_ActivatedLparProfile", "IBMHSC_LparProfile", "Element", "Setting", false, false, null)) != null) {
                            while (enumeration3.hasMoreElements()) {
                                cIMInstance3 = (CIMInstance)enumeration3.nextElement();
                                if (cIMInstance3 == null) continue;
                                unsignedInt83 = (UnsignedInt8)CIMUtils.getPropertyValue(cIMInstance3, "SFPSurveillance");
                                if (unsignedInt83 == null || unsignedInt83.intValue() != 1) break;
                                bl3 = true;
                                break;
                            }
                        }
                        partitionInfo = new PartitionInfo(string4, unsignedInt8, bl3, !bl, string5);
                    }
                    if (string4 == null || partitionInfo == null) continue;
                    hashtable2.put(string4, partitionInfo);
                }
            }
        }
        return hashtable2;
    }

    public static Object getPropertyValue(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = null;
        CIMValue cIMValue = null;
        cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            return cIMValue.getValue();
        }
        return null;
    }

    public static String getHMCMTMS(String string, String string2) throws CIMException {
        CIMObjectPath cIMObjectPath = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Vector<CIMProperty> vector = null;
        Vector<CIMProperty> vector2 = null;
        CIMValue cIMValue = null;
        short s = 0;
        int n = 0;
        String string3 = null;
        String string4 = CIMUtils._getHostName();
        cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
        if (cIMObjectPath != null) {
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath.addKey("Name", new CIMValue((Object)(string + '*' + string2)));
            vector2 = new Vector<CIMProperty>();
            vector2.setSize(1);
            vector2.setElementAt(new CIMProperty("SlotID", new CIMValue((Object)new UnsignedInt8(0), new CIMDataType(1))), 0);
            cIMValue = HscUtil.invokeCIMMethod(string4, cIMObjectPath, "GetHostHscInfoSlotID", null, vector2);
            if (cIMValue == null) {
                throw new CIMException();
            }
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).shortValue();
            string3 = "";
            vector = new Vector<CIMProperty>();
            vector.setSize(2);
            vector.setElementAt(new CIMProperty("SlotID", new CIMValue((Object)new UnsignedInt8(s))), 0);
            vector.setElementAt(new CIMProperty("DataTag", new CIMValue((Object)new String("HscName"))), 1);
            vector2 = new Vector();
            vector2.setSize(2);
            vector2.setElementAt(new CIMProperty("DataLength", new CIMValue((Object)new UnsignedInt16(0), new CIMDataType(3))), 0);
            vector2.setElementAt(new CIMProperty("Data", new CIMValue((Object)"", new CIMDataType(9))), 1);
            cIMValue = HscUtil.invokeCIMMethod(string4, cIMObjectPath, "GetHscInfo", vector, vector2);
            if (cIMValue != null) {
                n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
                string3 = n > 0 ? ((string3 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue()) == null ? "" : string3.substring(0, 4) + "-" + string3.substring(4)) : "";
                return string3;
            }
            throw new CIMException();
        }
        throw new CIMException();
    }

    public static String getHMCMTM(String string, String string2) throws CIMException {
        String string3 = null;
        int n = 0;
        string3 = CIMUtils.getHMCMTMS(string, string2);
        if (string3.length() > 0 && (n = string3.indexOf(42)) != -1) {
            return string3.substring(0, n);
        }
        return "";
    }

    public static String getHMCMS(String string, String string2) throws CIMException {
        String string3 = null;
        int n = 0;
        string3 = CIMUtils.getHMCMTMS(string, string2);
        if (string3.length() > 0 && (n = string3.indexOf(42)) != -1) {
            return string3.substring(n + 1);
        }
        return "";
    }

    public static Hashtable getComponentsOfBPA(String string, String string2) throws CIMException {
        Hashtable<String, String> hashtable = null;
        Hashtable<String, Object> hashtable2 = null;
        CIMObjectPath cIMObjectPath = null;
        String string3 = null;
        String string4 = null;
        Vector vector = null;
        Vector<CIMProperty> vector2 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        Object var13_13 = null;
        CIMValue cIMValue = null;
        String string5 = CIMUtils._getHostName();
        hashtable2 = new Hashtable<String, Object>();
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_Frame");
        hashtable.put("Name", string + '*' + string2);
        cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscV3_2");
        if (cIMObjectPath != null) {
            Object object;
            if (hashtable != null) {
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    string3 = (String)object.nextElement();
                    string4 = (String)hashtable.get(string3);
                    cIMObjectPath.addKey(string3, new CIMValue((Object)string4));
                }
            }
            vector = new Vector();
            vector2 = new Vector<CIMProperty>();
            vector2.addElement(new CIMProperty("IODrawerMtms", new CIMValue(var9_9, new CIMDataType(29))));
            vector2.addElement(new CIMProperty("IOMatchingCECMtms", new CIMValue(var10_10, new CIMDataType(29))));
            vector2.addElement(new CIMProperty("IOCageNum", new CIMValue(var11_11, new CIMDataType(21))));
            vector2.addElement(new CIMProperty("CECMtms", new CIMValue(var12_12, new CIMDataType(29))));
            vector2.addElement(new CIMProperty("CECCageNum", new CIMValue(var13_13, new CIMDataType(21))));
            cIMValue = HscUtil.invokeCIMMethod(string5, cIMObjectPath, "GetFrameInfo", null, vector2);
            if (cIMValue != null) {
                Object object2;
                Vector vector3;
                object = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                if (object != null) {
                    vector3 = new Vector();
                    object2 = ((Vector)object).iterator();
                    while (object2.hasNext()) {
                        vector3.addElement(CIMUtils.replaceFirst((String)object2.next(), '*', '_'));
                    }
                    if (vector3.size() > 0) {
                        hashtable2.put("1", vector3);
                    }
                }
                if ((vector3 = (Vector)((CIMProperty)vector2.elementAt(3)).getValue().getValue()) != null) {
                    object2 = new Vector();
                    Iterator iterator = vector3.iterator();
                    while (iterator.hasNext()) {
                        ((Vector)object2).addElement(CIMUtils.replaceFirst((String)iterator.next(), '*', '_'));
                    }
                    if (((Vector)object2).size() > 0) {
                        hashtable2.put("0", object2);
                    }
                }
            }
        }
        if (hashtable2.size() == 0) {
            return null;
        }
        return hashtable2;
    }

    public static Vector getBPAs() throws CIMException {
        Enumeration enumeration = null;
        Vector<String> vector = null;
        String string = null;
        CIMObjectPath cIMObjectPath = null;
        CIMInstance cIMInstance = null;
        boolean bl = false;
        cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscV3_2");
        enumeration = CIMUtils.getInstances("IBMHSC_Frame", cIMObjectPath);
        while (enumeration.hasMoreElements()) {
            cIMInstance = (CIMInstance)enumeration.nextElement();
            bl = (Boolean)cIMInstance.getProperty("isFrame").getValue().getValue();
            if (!bl) continue;
            string = (String)cIMInstance.getProperty("Name").getValue().getValue();
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(CIMUtils.replaceFirst(string, '*', '_'));
        }
        return vector;
    }

    public static Vector getBPAs(String string, String string2) throws CIMException {
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration = null;
        Vector<String> vector = null;
        String string3 = null;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = null;
        String string4 = CIMUtils._getHostName();
        boolean bl = false;
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        enumeration = CIMUtils.getAssociators("IBMHSC_ComputerSystem", "IBMHSC_FrameCompSys", "IBMHSC_Frame", hashtable);
        while (enumeration.hasMoreElements()) {
            cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            cIMInstance = HscUtil.getCIMInstance(string4, cIMObjectPath, false);
            if (cIMInstance == null) continue;
            bl = (Boolean)cIMInstance.getProperty("isFrame").getValue().getValue();
            if (bl) {
                string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
                Trace.trace(TRACE_MASKD, "Real frame found in getBPAs : " + string3);
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement(CIMUtils.replaceFirst(string3, '*', '_'));
                continue;
            }
            Trace.trace(TRACE_MASKD, "Fake frame found in getBPAs.");
        }
        return vector;
    }
}

